<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dialogflow;

class GoogleCloudDialogflowV2KnowledgeOperationMetadata extends \Google\Model
{
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  public const STATE_PENDING = 'PENDING';
  public const STATE_RUNNING = 'RUNNING';
  public const STATE_DONE = 'DONE';
  /**
   * @var string
   */
  public $doneTime;
  protected $exportOperationMetadataType = GoogleCloudDialogflowV2ExportOperationMetadata::class;
  protected $exportOperationMetadataDataType = '';
  /**
   * @var string
   */
  public $knowledgeBase;
  /**
   * @var string
   */
  public $state;

  /**
   * @param string $doneTime
   */
  public function setDoneTime($doneTime)
  {
    $this->doneTime = $doneTime;
  }
  /**
   * @return string
   */
  public function getDoneTime()
  {
    return $this->doneTime;
  }
  /**
   * @param GoogleCloudDialogflowV2ExportOperationMetadata $exportOperationMetadata
   */
  public function setExportOperationMetadata(GoogleCloudDialogflowV2ExportOperationMetadata $exportOperationMetadata)
  {
    $this->exportOperationMetadata = $exportOperationMetadata;
  }
  /**
   * @return GoogleCloudDialogflowV2ExportOperationMetadata
   */
  public function getExportOperationMetadata()
  {
    return $this->exportOperationMetadata;
  }
  /**
   * @param string $knowledgeBase
   */
  public function setKnowledgeBase($knowledgeBase)
  {
    $this->knowledgeBase = $knowledgeBase;
  }
  /**
   * @return string
   */
  public function getKnowledgeBase()
  {
    return $this->knowledgeBase;
  }
  /**
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDialogflowV2KnowledgeOperationMetadata::class, 'Google_Service_Dialogflow_GoogleCloudDialogflowV2KnowledgeOperationMetadata');
