<!DOCTYPE html>
<html lang="en">

<head>
    <title>Chat Dashboard</title>
    <?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/css/bootstrap-select.css" />
</head>

<body>
    <?php echo $__env->make('includes.flash-sms', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('includes.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('includes.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <div id="frame">
                <?php echo $__env->make('chat.chat-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="content">
                    <div class="contact-profile contact-profile-two">
                        <div class="profile-info">
                            <div class="profile-icon">
                                <i class="fa fa-bullhorn" aria-hidden="true"></i>
                            </div>
                            <div class="meta-data">
                                <p><?php echo e($resp['broadcast_info']->name ?? ''); ?></p>
                                <small>
                                    <strong>Users</strong>: <?php echo e(count(json_decode($resp['broadcast_info']->user_list))); ?> | 
                                    <strong>Tags</strong>: <?php $__currentLoopData = json_decode($resp['broadcast_info']->tag); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge bg-gradient-warning text-dark" style="font-size: 10px; padding: 2px 6px;"><?php echo e($val); ?></span>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </small>
                            </div>
                        </div>
                        <div class="social-media">
                            <i class="feather icon-edit" data-toggle="modal" data-target="#editBroadCastModel" title="Edit Broadcast"></i>
                            <!-- <i class="feather icon-more-vertical" title="More Options"></i> -->
                        </div>
                    </div>
                    <div class="messages">
                        <ul class="thisChat"></ul>
                    </div>
                    <div class="message-input">
                        <div class="wrap">
                            <i onclick="onClickFileIcon()" class="fa fa-paperclip attachment" aria-hidden="true"
                                title="Attach Files"></i>
                            <input type="file" name="send_file" class="d-none" onchange="fileAttachment()">
                            <input type="text" name="send_message" placeholder="Type your message here..." />
                            <button class="submit" title="Send Message">
                                <i class="fa fa-paper-plane" aria-hidden="true"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->make('includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div id="editBroadCastModel" class="modal fade" tabindex="-1" role="dialog"
        aria-labelledby="editBroadCastModelLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">

                <div class="modal-header">
                    <h5 class="modal-title" id="editBroadCastModelLabel">Edit broadcast</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                </div>

                <div class="modal-body">

                    <form action="<?php echo e(route('chat-broadcast-update')); ?>" id="storeUser" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="row">

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="brname">Name <span class="text-danger">*</span></label>
                                    <input type="text" name="name" value="<?php echo e($resp['broadcast_info']->name ?? ''); ?>"
                                        class="form-control" placeholder="Broadcast Name" />
                                    <input type="hidden" name="uid" value="<?php echo e($resp['broadcast_info']->id ?? ''); ?>"
                                        class="form-control" />
                                </div>
                                <div class="form-group">
                                    <label for="assignUser">Tags <span class="text-danger">*</span></label>
                                    <select id="assignUser" name="tags[]" class="form-control selectpicker" multiple
                                        data-live-search="true" required>

                                        <option value="new"
                                            <?php if(in_array('new', json_decode($resp['broadcast_info']->tag))): ?> selected
                                            <?php endif; ?>>New Trainee</option>
                                        <option value="old"
                                            <?php if(in_array('old', json_decode($resp['broadcast_info']->tag))): ?> selected
                                            <?php endif; ?>>Old Trainee</option>
                                        <option value="active"
                                            <?php if(in_array('active', json_decode($resp['broadcast_info']->tag))): ?> selected
                                            <?php endif; ?>>Active Trainee</option>
                                        <option value="inactive"
                                            <?php if(in_array('inactive', json_decode($resp['broadcast_info']->tag))): ?> selected
                                            <?php endif; ?>>Inactive Trainee</option>
                                        <option value="hold"
                                            <?php if(in_array('hold', json_decode($resp['broadcast_info']->tag))): ?> selected
                                            <?php endif; ?>>On Hold Trainee</option>
                                        <option value="pending"
                                            <?php if(in_array('pending', json_decode($resp['broadcast_info']->tag))): ?> selected
                                            <?php endif; ?>>Payment Pending</option>
                                        <option value="archived"
                                            <?php if(in_array('archived', json_decode($resp['broadcast_info']->tag))): ?> selected
                                            <?php endif; ?>>Archived</option>
                                        <option value="confidential"
                                            <?php if(in_array('confidential', json_decode($resp['broadcast_info']->tag))): ?>
                                            selected <?php endif; ?>>Confidential</option>
                                        <option value="other"
                                            <?php if(in_array('other', json_decode($resp['broadcast_info']->tag))): ?> selected
                                            <?php endif; ?>>Other</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="assignUser">Users <span class="text-danger">*</span></label>
                                    <select id="assignUser" name="assignuser[]" class="form-control selectpicker"
                                        multiple data-live-search="true" required>
                                        <?php $__currentLoopData = $resp['all_users']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($list->id); ?>"
                                                <?php if(in_array($list->id, json_decode($resp['broadcast_info']->user_list))): ?>
                                                selected <?php endif; ?>><?php echo e($list->name); ?> - <?php echo e($list->email); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn  bg-gradient-info pr">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <?php echo $__env->make('chat.chat-common', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;

        <script>
                var attached_image = "";
                var authUserId = "<?php echo e(Auth::id()); ?>";
                function fileAttachment() {
                    var file = $('input[name=send_file]')[0].files[0];
                    if (file) {
                        var reader = new FileReader();
                        reader.onload = function (e) {
                            attached_image = e.target.result.split(',')[1];
                            sendMessage();
                        };
                        reader.readAsDataURL(file);
                    }
                }

                function onClickFileIcon() {
                    $('input[name=send_file]').trigger('click');
                }

                $(".messages").animate({ scrollTop: $(document).height() }, "fast");
                $('.submit').click(function () {
                    sendMessage();
                });

                // $(window).on('keydown', function (e) {
                //     if (e.which == 13) {
                //         sendMessage();
                //         return false;
                //     }
                // });
        </script>
        <script>
            function sendMessage() {
                var message = $('input[name=send_message]').val();
                if (message == "" || message == undefined) {
                    $('input[name=send_message]').css('border', 'red 1px solid');
                }
                $.ajax({
                    url: '<?php echo e(route("send-broadcast-chat")); ?>',
                    type: 'PUT',
                    data: {
                        message: message,
                        key_id: '<?php echo e($resp["broadcast_info"]->id ?? 0); ?>',
                        _token: "<?php echo e(csrf_token()); ?>",
                        attached_image: attached_image
                    },
                    success: function (result) {
                        $("#gen-loading").hide();
                        Swal.fire({
                            position: "top-end",
                            icon: "success",
                            title: result,
                            showConfirmButton: false,
                            timer: 1500
                        }).then(() => {
                            $('input[name=send_message]').val('');
                            newMessage()
                        });
                    },
                    error: function (request, msg, error) {
                        $("#gen-loading").hide();
                        console.log(request)
                        Swal.fire({
                            position: "top-end",
                            icon: "error",
                            title: request.responseJSON,
                            showConfirmButton: false,
                            timer: 1500
                        }).then(() => {
                        });
                    }
                }
                );
            }
            $(document).on('input', 'input[name=send_message]', (res) => {
                if (res.target.value == '') {
                    $('input[name=send_message]').css('border', 'red 1px solid');
                } else {
                    $('input[name=send_message]').css('border', '#d9d9d9 1px solid');
                }
            });
            function newMessage() {
                var options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric', hour: "numeric", minute: "numeric", dayPeriod: "narrow" };
                $.ajax({
                    url: '<?php echo e(route("get-broadcast-chat")); ?>', type: 'PUT', data: { key_id: '<?php echo e($resp["broadcast_info"]->id ?? 0); ?>', _token: "<?php echo e(csrf_token()); ?>" },
                    success: function (result) {
                       var dataHtml = '';
                    result.forEach(function (obj) {
                        var today = new Date(obj.created_at);
                        var attachments = "";
                        if (obj.attechments) {
                            try {
                                var files = JSON.parse(obj.attechments);
                                if (Array.isArray(files)) {
                                    attachments += `<div class="attachment-container">`;
                                    files.forEach(function (f) {
                                        var fileUrl = `<?php echo e(asset('ftj/storage/chat_attached')); ?>/` + f;
                                        var ext = f.split('.').pop().toLowerCase();
                                        var isImage = ['jpg', 'jpeg', 'png', 'gif', 'webp'].includes(ext);

                                        if (isImage) {
                                            attachments += `
                                                <div class="attachment-item image-attachment">
                                                    <img onerror="this.onerror=null;this.src='<?php echo e(asset('ftj/storage/app/default-user.jpg')); ?>'" src="${fileUrl}" />
                                                    <a href="${fileUrl}" download="${f}" class="download-btn" title="Download Image">
                                                        <i class="fa fa-download"></i>
                                                    </a>
                                                </div>`;
                                        } else {
                                            var icon = 'fa-file-alt';
                                            if (ext === 'pdf') icon = 'fa-file-pdf';
                                            else if (['doc', 'docx'].includes(ext)) icon = 'fa-file-word';
                                            else if (['xls', 'xlsx'].includes(ext)) icon = 'fa-file-excel';
                                            else if (['zip', 'rar'].includes(ext)) icon = 'fa-file-archive';

                                            attachments += `
                                                <div class="attachment-item doc-attachment">
                                                    <div class="doc-info">
                                                        <i class="fa ${icon} file-icon"></i>
                                                        <span class="file-name" title="${f}">${f}</span>
                                                    </div>
                                                    <a href="${fileUrl}" download="${f}" class="download-btn" title="Download Document">
                                                        <i class="fa fa-download"></i>
                                                    </a>
                                                </div>`;
                                        }
                                    });
                                    attachments += `</div>`;
                                }
                            } catch (e) {
                                console.error("Attachment parsing error:", e);
                            }
                        }

                        var isMe = (obj.sender_user_id == authUserId);
                        var chatClass = isMe ? 'me' : 'other';
                        var displayName = isMe ? 'You' : (obj.sender_name);

                        var profileImg = obj.sender_profile;
                        if (!profileImg) {
                            profileImg = `https://ui-avatars.com/api/?name=${encodeURIComponent(displayName)}&background=8e44ad&color=fff`;
                        }
                        var displayMsg = (obj.message && obj.message !== "null") ? obj.message : "";
                        var timeString = '';
                        if (obj?.created_at) {
                            const fixedDate = new Date(obj.created_at.replace('Z', ''));
                            timeString = fixedDate.toLocaleString('en-IN', {
                                day: '2-digit',
                                month: 'short',
                                year: 'numeric',
                                hour: '2-digit',
                                minute: '2-digit',
                                hour12: true
                            }).toLowerCase();
                        }
                        if (isMe) {
                            dataHtml += `
                                <div class="chat-row me">
                                    <div class="chat-bubble-wrapper">
                                        <div class="chat-bubble">
                                            ${displayMsg}
                                            ${attachments}
                                        </div>
                                        <div class="chat-meta">
                                            ${timeString} <i class="fa fa-check-double tick-icon"></i>
                                        </div>
                                    </div>
                                </div>
                            `;
                        } else {
                            dataHtml += `
                                <div class="chat-row other">
                                    <img onerror="this.onerror=null;this.src='<?php echo e(asset('ftj/storage/app/default-user.jpg')); ?>'" src="${profileImg}" class="chat-avatar" alt="${displayName}">
                                    <div class="chat-bubble-wrapper">
                                        <div class="chat-user-name">${displayName}</div>
                                        <div class="chat-bubble">
                                            ${displayMsg}
                                            ${attachments}
                                            <div class="chat-footer-info">
                                                <span class="small">${timeString}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            `;
                        }
                    });
                    $('.thisChat').html(dataHtml);
                    },
                    error: function (request, msg, error) { }
                }
                );
            }

            $(document).on('click', '.getNew', () => {
                Swal.fire({
                    title: "Start new chat",
                    html: `
                <ul style="list-style-type: none; padding: 0;">
                    <?php $__currentLoopData = $resp['newChat']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="contact" style="border:1px solid #e2e2e2">
                            <a class="text-dark " href="<?php echo e(route('chat-details', ['user' => openssl_encrypt($list->id, 'AES-128-CTR', 'kulwindermatharu', 0, 'kulwindermatharu')])); ?>">
                                <div class="wrap ">
                                    <span class="contact-status online"></span>
                                    <img onerror="this.onerror=null;this.src='<?php echo e(asset('ftj/storage/app/default-user.jpg')); ?>'" src="<?php echo e($list->image); ?>" width="50" />
                                    <div class="meta">
                                        <p class="name"><?php echo e($list->name); ?>

                                            <br><small><strong>Trainer</strong> : <?php echo e($list->currentTrainer->user->name ?? ''); ?></small>
                                        </p>
                                    </div>
                                </div>
                            </a> 

                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>

                `,
                    showConfirmButton: false,
                });
            });

        </script>

</body>

</html><?php /**PATH D:\xampp\htdocs\fitness-junction-main\ftj\resources\views/chat/chat-broadcast-detail.blade.php ENDPATH**/ ?>