<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ApiLoginController;
use App\Http\Controllers\ApiMainController;
use App\Http\Controllers\MainController;
use App\Http\Controllers\PaymentController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/


Route::controller(ApiLoginController::class)->group(function () {
    Route::post('login', 'login');
    Route::post('signup', 'signup');
    Route::post('logout', 'logout');

    //Forgot Password
    Route::post('forgot/verify-request', 'forgotVerifyRequest');
    Route::post('forgot/verify-otp', 'forgotVerifyOTP');
    Route::post('forgot/change-password', 'forgotChangePassword');

    Route::post('login-with-google-auth','authWithGoogle');

    Route::post('login-with-apple-auth','authWithApple');
    
    Route::get('test-notify','testPushNotification');
});


Route::controller(ApiMainController::class)->group(function () {
    Route::post('/countries', 'getAllCountries');
    Route::post('/countries/{cid}', 'getSelectedState');
    Route::post('/countries/{cid}/{sid}', 'getSelectedCity');

    Route::post('/languages', 'getActiveLanguages');
});

Route::get('/get-chart/{title}/{start}/{end}', [ApiMainController::class,'getChart'])->name('getChart');
Route::get('/connect-google-account', [MainController::class,'connect'])->name('connect_health_data');
Route::get('/temp-google-account', [MainController::class,'connectGoogleTempAuth'])->name('temp_health_data');
Route::get('/i18n/{file}',[MainController::class,'getLanguageFile'])->name('language_files');


Route::group(['middleware' => ['auth:api']], function () { 

    //Connect Goole
    Route::get('/fetch_health_data', [MainController::class,'fetch_health_data'])->name('fetch_health_data');
    // tempAuth

    
    
    

    Route::controller(ApiMainController::class)->group(function () {
        //Setup Profile
        Route::post('init-profile', 'setprofile');

        //Push Notification Token Save
        Route::post('/save-token', 'savePushNotificationToken');

        //Diet Plan
        Route::post('/my-diet','getMyDietPlan');

        //Diet Plan
        Route::post('/my-calories','getMyCalories');

        //Plans
        Route::get('get-plans', 'browsePlans');
        Route::post('activate-plan', 'activatePlan');

        //Application Home Page
        Route::post('dashboard', 'Dashboard');

        // Calculators 
        Route::post('bmr-calculator', 'bmrCalc');
        Route::post('calorie-calculator', 'calorieCalc');

        //Exercise Videos
        Route::get('exersise-video-categories', 'videoCategories');
        Route::post('exersise-videos', 'exerciseVideos');

        // Manage Meal Images
        Route::get('my-missed-meal-upload', 'missedMeals');
        Route::post('meal-upload-history', 'mealHistory');
        Route::post('upload-meal-picture', 'uploadMealPicture');//Done 
        Route::post('retake-meal-picture', 'retakeMealPicture');
        Route::post('recipe-list', 'recipeList');//Created

        // Manage Requests
        Route::get('request-a-call-book', 'requestACallBook');
        Route::post('consultation-request-send-query', 'consultationQuerySend');
        Route::get('requests-history', 'requestHistory');

        //Manage Weekly Form History
        Route::post('/weekly-update-form', 'weeklyUpdateForm');
        Route::get('/weekly-update-form-history', 'weeklyUpdateFormHistory');

        Route::post('/weekly-update-form-v2', 'weeklyUpdateFormV2');
        Route::post('/weekly-diet-follow-sts', 'dietFollowWeeklySts');

        //Manage Meditation
        Route::post('/add-meditation', 'addNewMeditation');
        Route::post('/meditation-info', 'meditationInfo');//Created
        Route::post('/meditation-categories', 'meditationCategories');//Created
        Route::post('/meditation-list', 'meditationList');//Created
        Route::post('/meditation/{uuid}', 'meditationDetail');//Created
        Route::post('/meditation/{uuid}/completed', 'meditationCompleted');//New
        Route::get('/upcoming-meditation', 'upcomingMeditation');

        //Recipe Guide
        Route::post('/recipe-guide-list', 'recipeGuideList');
        Route::post('/recipe-guide/{uuid}', 'recipeGuideDetail');

        //Chats
        Route::post('/chat-list', 'getChatHome');
        Route::post('/chat-detail/{t_id}', 'getChatDetail');
        Route::post('/chat/send-message', 'sendChatMessage');

        //Manage Help & Support
        Route::post('/send-help-query', 'sendHelpQuery');
        Route::post('/book-request-call', 'bookRequestCall');
        Route::get('/get-contact-details', 'getContactDetails');

        //My Trainer
        Route::post('/workout-list', 'workoutList');
        Route::post('/workout-find', 'workoutFind');
        Route::post('/workout-plan-days/{uuid}', 'workoutPlanDays');
        Route::post('/workout-days-detail/{uuid}', 'workoutDaysDetail');

        Route::post('/workout-log', 'workoutLogSave');

        //Profile
        Route::post('/edit-profile','editUserProfile');//Done
        Route::post('/change-password','getUserPasswordChange');//Done

        Route::post('/all-reminders','allReminders');//Created
        Route::post('/add-reminder','addReminder');//Created

        Route::post('/disable-reminder','disableReminder');//Created
        Route::post('/trash-reminder','trashReminder');//Created
        Route::post('/update-reminder','updateReminder');//Created

        //privacy-policy | terms-and-conditions
        Route::post('/settings/{name}','getSettingData');//Created

        // Route::post('/daily-meditation','getUserProfile');//New
        //Days list
        // Route::post('/focus-builder','getUserProfile');//New
        //Days Detail
        // Route::post('/meditation-completion','getUserProfile');//New

        //Food List according breakfast|lunch|Snacks|Dinner (kcal)
        // Route::post('/food-timing-list','getUserProfile');
        //food-reminder Remonders List
        // Route::post('/food-reminder','getUserProfile');

        // Route::post('/addmeal-picture','getUserProfile');

        // Route::post('/recipe-list-braekfast','getUserProfile');

        Route::post('/form-builder-guide','formBuilderGuide');//Created
        Route::post('/form-builder-workouts','formBuilderWorkouts');//Created
        Route::post('/form-builder-workouts/{uuid}','formBuilderGuideDetail');//Created
        Route::post('/form-upload-your-video','formBuilderUploadVideo');//Created

        Route::post('/body-measurments/{type}','bodyMeasurmentUpdate');//Created
        Route::post('/body-measurments-compare','bodyMeasurment');//New

        Route::post('/update-physique','updatePhysique');//Created 
        Route::post('/update-physique-compare','updatePhysiqueCompare');//Created     

        Route::post('/notifications','notificationList');

        Route::post('/recipe-list','recipeList');

        Route::post('/recipe-ingredients','recipeIngredients');
        Route::post('/create-own-recipe-ingredient','storeRecipeIngredients');
        Route::post('/log-meal-from-ingredients','logFoodFromIngredients');
        Route::post('/log-meal-from-meallist','logMealFromMealList');

        Route::post('/save-recipe-ingredients','saveRecipeIngredients');

        Route::post('/fav-recipe-update', 'updateFavRecipe');
        Route::post('/save-recipe-reference', 'saveRecipeReference');
        Route::post('/get-recipe-reference', 'getRecipeReference');

        Route::post('/medtation-deepsleep','deepSleepList');

        //Request Premium
        Route::post('request-premium','requestPremium');

        //Notification Settings
        Route::post('get-notification-settings', 'getNotificationSettings');
        Route::post('save-notification-settings', 'saveNotificationSettings');
        
       //Record Meal
       Route::post('record-today-meal','recordTodayMeal');
       Route::post('/specific-recipe-list','specificRecipeList');

       //Today Meal Insights
       Route::post('get-today-insights','todayCaloriesInsights');

       //Get Settings Value
       Route::post('get-settings/{name}','getSettings');

        //Progress Tracker
        Route::post('progress-tracker/measurment','getMeasurementTracker');//Init
        Route::post('progress-tracker/weight','getWeightTracker');//Init

        Route::get('progress-tracker/machine-type','getMachineType');
        Route::post('progress-tracker/strength','getStrengthTracker');
       
        Route::post('update-weight','updateWeight');
    });

    Route::controller(PaymentController::class)->group(function () {
         //Purchase Plans
         Route::post('/purchase-plan/{id}', 'purchaseAPlan');

    });
});

