<!DOCTYPE html>
<html lang="en">

<head>
    <title>Login</title>
    @include('includes.header')
    <style>

        html {
        height: 100%;
        }
        body {
        margin:0;
        padding:0;
        font-family: sans-serif;
        background: linear-gradient(#141e30, #243b55);
        }

        .login-box {
        position: absolute;
        top: 50%;
        left: 50%;
        width: 400px;
        padding: 40px;
        transform: translate(-50%, 40%);
        background: rgb(241 240 240);
        box-sizing: border-box;
        box-shadow: 0 15px 25px rgba(0,0,0,.6);
        border-radius: 10px;
        }

        .login-box h2 {
        margin: 0 0 30px;
        padding: 0;
        color: #243b55;
        text-align: left;
        }

        .login-box .user-box {
        position: relative;
        }

        .login-box .user-box input {
        width: 100%;
        padding: 6px 0;
        font-size: 13px;
        color: #243b55;
        margin-bottom: 10px;
        border: none;
        border-bottom: 1px solid #243b55;
        outline: none;
        background: transparent;
        }
        .login-box .user-box label {
        /* position: absolute;
        top:0; */
        /* left: 0; */
        /* padding: 10px 0; */
        font-size: 14px;
        color: #243b55;
        pointer-events: none;
        transition: .5s;
        }

        /* .login-box .user-box input:focus ~ label,
        .login-box .user-box input:valid ~ label {
        top: -20px;
        left: 0;
        color: #243b55;
        font-size: 12px;
        } */

        .login-box form button {
        position: relative;
        display: inline-block;
        padding: 10px 20px;
        color: #243b55;
        font-size: 16px;
        background: transparent;
        text-decoration: none;
        text-transform: uppercase;
        overflow: hidden;
        transition: .5s;
        margin-top: 40px;
        border:none;
        letter-spacing: 4px
        }

        .login-box button:hover {
        background: #243b55;
        color: #fff;
        border:none;
        border-radius: 5px;
        box-shadow: 0 0 5px #243b55,
                    0 0 25px #243b55,
                    0 0 50px #243b55,
                    0 0 100px #243b55;
        }

        .login-box button span {
        position: absolute;
        display: block;
        }

        .login-box button span:nth-child(1) {
        top: 0;
        left: -100%;
        width: 100%;
        height: 2px;
        background: linear-gradient(90deg, transparent, #243b55);
        animation: btn-anim1 1s linear infinite;
        }

        @keyframes btn-anim1 {
        0% {
            left: -100%;
        }
        50%,100% {
            left: 100%;
        }
        }

        .login-box button span:nth-child(2) {
        top: -100%;
        right: 0;
        width: 2px;
        height: 100%;
        background: linear-gradient(180deg, transparent, #243b55);
        animation: btn-anim2 1s linear infinite;
        animation-delay: .25s
        }

        @keyframes btn-anim2 {
        0% {
            top: -100%;
        }
        50%,100% {
            top: 100%;
        }
        }

        .login-box button span:nth-child(3) {
        bottom: 0;
        right: -100%;
        width: 100%;
        height: 2px;
        background: linear-gradient(270deg, transparent, #243b55);
        animation: btn-anim3 1s linear infinite;
        animation-delay: .5s
        }

        @keyframes btn-anim3 {
        0% {
            right: -100%;
        }
        50%,100% {
            right: 100%;
        }
        }

        .login-box button span:nth-child(4) {
        bottom: -100%;
        left: 0;
        width: 2px;
        height: 100%;
        background: linear-gradient(360deg, transparent, #243b55);
        animation: btn-anim4 1s linear infinite;
        animation-delay: .75s
        }

        @keyframes btn-anim4 {
        0% {
            bottom: -100%;
        }
        50%,100% {
            bottom: 100%;
        }
        }

    </style>
</head>
<body>
@include('includes.flash-sms')
<!-- [ auth-signin ] start -->
<div class="login-box">
  
  <h2>Login<br><small style="font-size:20px;font-weight:bold;">Fitness Junction</small></h2>
  <form method="post" action="{{route('post.login')}}" id="sendLogin">
  @csrf
    <div class="user-box">
        <label>Email</label>
      <input type="email" name="email" required >
     
    </div>
    <div class="user-box">
    <label>Password</label>
      <input type="password" name="password" required >
      
    </div>
    <button type="submit">
      <span></span>
      <span></span>
      <span></span>
      <span></span>
      Submit
    </button>
  </form>
</div>

<!-- [ auth-signin ] end -->
@include('includes.footer')
<script>
    $(document).on('submit','#sendLogin',()=>{
        if($('input[name=email]').val()==""){
             Swal.fire({
                position: 'center',
                icon: 'error',
                title: 'Enter Email Address',
                showConfirmButton: false,
                timer: 1500
            });
            return false;
        }
        if($('input[name=password]').val()==""){
            Swal.fire({
                position: 'center',
                icon: 'error',
                title: 'Enter Password',
                showConfirmButton: false,
                timer: 1500
            });
            return false;
        }
        $('#sendLogin').submit();
    });
</script>
</body>

</html>
