<!DOCTYPE html>
<html lang="en">

<head>
    <title>Weekly Updates </title>
    @include('includes.header')
     <script src="{{asset('assets/js/bs/bootstrap.min.css')}}"></script>
    <script src="{{asset('assets/js/bs/dataTables.bootstrap5.css')}}"></script> 

    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Weekly Updates</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Weekly Updates</h5>
                            <div class="row">
                                <div class="col-xl-5"></div>
                       
                                <div class="col-xl-3">
                                    <div >Date Range</div>
                                    <div id="reportrange" class="form-control float-left" style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc; width: 100%">
                                        <i class="fa fa-calendar"></i>&nbsp;
                                        <span></span> <i class="fa fa-caret-down"></i>
                                    </div>
                                </div>
                                <div class="col-xl-3">
                                    <div >User</div>
                                    <select class="form-control getUser" >
                                        <option value="all">All users</option>
                                        @foreach($users as $user)
                                        <option value="{{$user->id}}">{{$user->name}} - {{$user->email}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-xl-1">
                                    <button class="mt-4 p-2 btn bg-gradient-dark" id="reloadData"><i class="fa fa-refresh"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table id="getUserData" class="table table-striped" style="width:100%"></table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')
    
    <script src="{{asset('assets/js/bs/dataTables.js')}}"></script>
    <script src="{{asset('assets/js/bs/dataTables.bootstrap5.js')}}"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

    <script>
    
      
        $(document).on('change','#usertype',(res)=>{
            var type = res.target.value;
            if(type=="free"){
                $('.paidUserCheck').hide();
                $('#paid_plan').removeAttr('required');
            }
            if(type=="paid"){
                $('.paidUserCheck').show();
                $('#paid_plan').attr('required',true);
            }
            console.log(type)
        });

        $(document).on('submit','#storeUser',()=>{
            if($('input[name=password]').val()!=$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','red 1px solid');
                $('.err-msg').html('Recheck Passwords')
                return false;
            }
            $('#storeUser').submit();
        });
        $(document).on('input','input[name=password],input[name=confirm_password]',()=>{
            if($('input[name=password]').val()==$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','green 1px solid');
                $('.err-msg').html('')
            }
        });
    </script>

    <script type="text/javascript">
        var start = moment().subtract(6, 'days');
        var end = moment();
        var start_ = start.format('YYYY-MM-DD');
        var end_ = end.format('YYYY-MM-DD');
        $(function() {

         

            function cb(start, end) {
                $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
                start_ = $('#reportrange').data('daterangepicker').startDate.format('YYYY-MM-DD');
                end_ = $('#reportrange').data('daterangepicker').endDate.format('YYYY-MM-DD');
            }

            $('#reportrange').daterangepicker({
                startDate: start,
                endDate: end,
                ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                'This Year': [moment().startOf('year'), moment().endOf('year')],
                'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
                }
            }, cb);

            cb(start, end);

        });

        $(document).on('click','#reloadData',(res)=>{
            getData();
        });
        function getData(){
            $(document).ready(()=>{
                $('#getUserData').DataTable( {
                    "ajax": {
                        "url": "{{route('get-weekly-datatable')}}",
                        "data": function ( d ) {
                                d.startDate=start_;
                                d.endDate=end_;
                                d.selectedUser=$('.getUser').val();
                            },
                            "dataSrc": function ( json ) {
                                return json.data;
                            }
                    },
                    fixedHeader: true,
                    responsive: true,
                    processing: true,
                    serverSide: true,
                    columns: [
                        { data: 'id',title:"#" },
                        { data: 'user',title:"Name",orderable:false,render:function (data,row){
                            return data.name+'<br>'+data.email
                        }},
                        { data: 'descibe_diet',title:"Descibe Diet" },
                        { data: 'describe_workout',title:"Describe Workout" },
                        { data: 'suggestion',title:"Suggestion" },
                        { data: 'weight',title:"Weight" },
                        { data: 'date',title:"Update on" },

                    ],
                    language: {
                        searchPlaceholder: "Search ..."
                    },
                    retrieve: true,
                }).ajax.reload();
            });
        }
        this.getData();
    </script>
</body>

</html>