<!DOCTYPE html>
<html lang="en">

<head>
    <title>Call Requests</title>
    @include('includes.header')
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Call Requests</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Call Requests</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>User</th>
                                            <th>Message</th>
                                            <th>Status</th>
                                            @if(permission('call_request','update') || permission('call_request','delete'))
                                            <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($query as $list)
                                        <tr>
                                            <td>{{$list->id}}</td>
                                            <td>{{$list->user->name}}</td>
                                            <td>{{$list->message}}</td>
                                            <td>
                                                @if($list->status==1)<span class="badge bg-gradient-warning">Pending</span>@endif
                                                @if($list->status==2)<span class="badge bg-gradient-success">Completed</span>@endif
                                            </td>
                                            @if(permission('call_request','update') || permission('call_request','delete'))
                                            <td>
                                                @if($list->status==1)
                                                    @if(permission('call_request','update'))
                                                    <a href="{{route('call-request-status',['status'=>'complete','uid'=>$list->id])}}">
                                                        <button class="btn btn-sm bg-gradient-success">Mark Complete</button>
                                                    </a>
                                                    @endif
                                                    @if(permission('call_request','delete'))
                                                        <a href="{{route('call-request-status',['status'=>'delete','uid'=>$list->id])}}">
                                                            <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button>
                                                        </a>
                                                    @endif
                                                @endif
                                            </td>
                                            @endif
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="5" class="text-center"> Empty</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                                {{ $query->links('pagination.simple') }}
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')

    <!-- Apex Chart -->
    <script src="{{asset('assets/js/plugins/apexcharts.min.js')}}"></script>
    <!-- custom-chart js -->
    <script src="{{asset('assets/js/pages/dashboard-main.js')}}"></script>

    <script>
        $(document).on('change','#usertype',(res)=>{
            var type = res.target.value;
            if(type=="free"){
                $('.paidUserCheck').hide();
                $('#paid_plan').removeAttr('required');
            }
            if(type=="paid"){
                $('.paidUserCheck').show();
                $('#paid_plan').attr('required',true);
            }
            console.log(type)
        });

        $(document).on('submit','#storeUser',()=>{
            if($('input[name=password]').val()!=$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','red 1px solid');
                $('.err-msg').html('Recheck Passwords')
                return false;
            }
            $('#storeUser').submit();
        });
        $(document).on('input','input[name=password],input[name=confirm_password]',()=>{
            if($('input[name=password]').val()==$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','green 1px solid');
                $('.err-msg').html('')
            }
        });
    </script>
</body>

</html>