<!DOCTYPE html>
<html lang="en">

<head>
    <title>App Plans</title>
    @include('includes.header')
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            <!-- @if(permission('plans','create'))<button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Add a New Plan</button>@endif -->
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >App Plans</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>App Plans</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Title</th>
                                            <th>Duration</th>
                                            <th>Price</th>
                                            <th>Final Price</th>
                                            <th>Discount</th>
                                            <th>Access</th>
                                            <th>Payment Mode</th>
                                            <th>Description</th>
                                            <th>Status</th>
                                            @if(permission('plans','update') || permission('plans','disable'))
                                            <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($plans as $index => $list)
                                        <tr>
                                            <td>{{$list->id}}</td>
                                            <td>{{$list->name}}</td>
                                            <td style="font-size:12px;">{{$list->duration}}</td>
                                            <td>@if($list->amount>0)<span class="badge bg-gradient-warning">&#8377; {{$list->amount}}</span> @else <span class="badge bg-gradient-success">Free</span> @endif</td>
                                            <td>@if($list->final_price>0)<span class="badge bg-gradient-info">&#8377; {{$list->final_price}}</span> @else <span class="badge bg-gradient-success">Free</span> @endif</td>
                                            <td>@if($list->discount>0)<span class="badge bg-gradient-info pr">{{$list->discount}}%</span> @endif</td>
                                            <td style="font-size:12px;"><ul style="list-style-type:none;padding:0px">
                                                @forelse($list->permissions as $val => $l_feature)
                                                   @if($l_feature==1) <li>- {{$val}}</li> @endif
                                                @empty
                                                    Access Level Not Assigned
                                                @endforelse</ul>
                                            </td>
                                            <td style="font-size:12px;">@if($list->amount>0){{$list->plan_type}}@endif</td>
                                            <td style="font-size:12px;">{{$list->description}}</td>
                                            <td>@if($list->status==1)
                                                    <span class="badge bg-gradient-success">Active</span>
                                                @elseif($list->status==0)
                                                    <span class="badge bg-gradient-danger">Disabled</span>
                                                @endif
                                            </td>
                                            @if(permission('plans','update') || permission('plans','disable'))
                                            <td>
                                            @if(permission('plans','update'))
                                                <button class="btn btn-sm bg-gradient-info pr"  data-toggle="modal" data-target="#exampleModalLive{{$index}}q"><i class="feather icon-edit"></i></button>
                                            @endif
                                            @if(permission('plans','disable'))
                                                <a href="{{route('app-plans-disable',['id'=>$list->id])}}">
                                                    <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-slash"></i></button>
                                                </a>
                                            @endif
                                            </td>
                                            @endif
                                            
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="4"> Empty</td>
                                        </tr>
                                        @endforelse
                                        
                                    </tbody>
                                </table>
                                {{ $plans->links('pagination.simple') }}
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')

    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add a New Plan</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <form>
                                <div class="form-group">
                                    <label for="plan_title">Title</label>
                                    <input type="text" class="form-control" id="plan_title" aria-describedby="emailHelp" placeholder="Enter Title">
                                </div>
                                <div class="form-group">
                                    <label for="plan_amount">Amount</label>
                                    <input type="number" class="form-control" id="plan_amount" placeholder="Amount">
                                </div>
                            </form>
                        </div>
                        <div class="col-md-6">
                            <form>
                                <div class="form-group">
                                    <label for="exampleFormControlSelect1">Duration</label>
                                    <select class="form-control" id="exampleFormControlSelect1">
                                        <option>Select Duration</option>
                                        <option>30 days - Subscription</option>
                                        <option>30 days - One Time</option>
                                        <option>90 days - Subscription</option>
                                        <option>90 days - One Time</option>
                                        <option>Lifetime</option>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="exampleFormControlSelect1">Description</label>
                                    <textarea class="form-control"></textarea>
                                </div>
                            </form>
                        </div>
                    
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn  bg-gradient-info pr">Submit</button>
                </div>
            </div>
        </div>
    </div>

    @forelse($plans as $index => $list)
        <div id="exampleModalLive{{$index}}q" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLive{{$index}}qLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLive{{$index}}qLabel">Edit Plan</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                    <form action="{{route('app-plans-update',['id'=>$list->id])}}" method="post">
                        @csrf
                        <div class="modal-body">
                            <div class="row">
                                <div class="col-md-12">
                                
                                        <div class="form-group">
                                            <label for="plan_title">Title</label>
                                            <input type="text" class="form-control" name="name" value="{{$list->name}}" id="title" aria-describedby="emailHelp" placeholder="Enter Title">
                                        </div>
                                        <div class="form-group">
                                            <label for="plan_amount">Price</label>
                                            <input type="number" class="form-control" name="price" value="{{$list->amount}}" id="amount" placeholder="Amount">
                                        </div>
                                        <div class="form-group">
                                            <label for="discount">Discount (%)</label>
                                            <input type="tel" maxlength="2" class="form-control" name="discount" id="discount" value="{{$list->discount}}" placeholder="Discount">
                                        </div>
                                        <div class="form-group">
                                            <label for="exampleFormControlSelect1">Description</label>
                                            <textarea class="form-control" name="description">{{$list->description}}</textarea>
                                        </div>
                                        <div class="form-group">
                                            <label for="exampleFormControlSelect1">Permissions</label>
                                            @forelse($list->permissions as $val => $l_feature)
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" id="inlineCheckbox1" name="permissions[]" value="{{$val}}" @if($l_feature==1) checked @endif>
                                                    <label class="form-check-label" for="inlineCheckbox1" >{{$val}}</label>
                                                </div>
                                            @empty
                                                Access Level Not Assigned
                                            @endforelse
                                        </div>
                                
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    @endforeach
    <!-- Apex Chart -->
    <script src="{{asset('assets/js/plugins/apexcharts.min.js')}}"></script>
    <!-- custom-chart js -->
    <script src="{{asset('assets/js/pages/dashboard-main.js')}}"></script>
</body>

</html>