<!DOCTYPE html>
<html lang="en">

<head>
    <title>Meditation List</title>
    @include('includes.header')
    <script src="https://cdn.tiny.cloud/1/vzsbabl41dquoqb8uiq1co621duklluitrrj6akhlplahhqx/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    <script>
    tinymce.init({
        selector: 'textarea',
        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link table mergetags | align lineheight | tinycomments | checklist numlist bullist indent outdent | emoticons charmap | removeformat',
        ai_request: (request, respondWith) => respondWith.string(() => Promise.reject("See docs to implement AI Assistant")),
    });
    </script>
</head>
<body>  
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            @if(permission('meditation','create')) <button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Add a New Mediation</button>@endif
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Mediation List</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Mediation List</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Title</th>
                                            <th>Short Title</th>
                                            <th>Video Type</th>
                                            <th>Description</th>
                                            <th>Category</th>
                                            <th>Status</th>
                                            @if(permission('meditation','update') || permission('meditation','delete'))
                                            <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($listing as $index=> $list)
                                        <tr>
                                            <td>{{$list->id}}</td>
                                            <td>{!! $list->title !!}</td>
                                            <td>{!! $list->short_title !!}</td>
                                            <td>{!! $list->video_type !!}</td>
                                            
                                            <td style="background:#9f9f9f">{!! wordwrap($list->description,70,"<br>") !!}</td>
                                            <td>{!! ($list->cat_uid->name??'<span class="badge badge-danger">Not Assigned</span>') !!}</td>
                                            <td>
                                                @if($list->status==1)<span class="badge bg-gradient-success">Active</span>@endif
                                                @if($list->status==2)<span class="badge bg-gradient-warning">Draft</span>@endif
                                                @if($list->status==0)<span class="badge bg-gradient-danger">Inactive</span>@endif
                                            </td>
                                            @if(!permission('meditation','update') || permission('meditation','delete'))
                                            <td>
                                                @if(permission('meditation','update'))
                                                    <a href="{{route('status-meditation',['id'=>$list->id])}}" onclick="return confirm('Change Status?')">
                                                        <button class="btn btn-sm bg-gradient-dark"><i class="feather icon-refresh-cw"></i></button>
                                                    </a>
                                                    <button class="btn btn-sm bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive{{$index}}q"><i class="feather icon-edit"></i></button>
                                                @endif
                                                @if(permission('meditation','delete'))
                                                    <a href="{{route('delete-meditation',['id'=>$list->id])}}" onclick="return confirm('Are you sure? Delete Meditation')">
                                                        <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button>
                                                    </a>
                                                @endif
                                            </td>
                                            @endif
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="5">Empty</td>
                                        </tr>
                                        @endforelse
                                        
                                    </tbody>
                                </table>
                                {{ $listing->links('pagination.simple') }}
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')

    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add a New Meditation</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('save-meditation')}}" method="post" >
                    @csrf
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="cat_uid_p">Categories</label>
                                <select type="text" class="form-control" name="cat_uid" id="cat_uid_p" required placeholder="Category">
                                    <option value="" selected disabled>Select Category</option>
                                   @foreach($categories as $list) <option value="{{$list->uuid}}" >{{$list->name}}</option> @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="title_p">Title</label>
                                <input type="text" class="form-control" name="title" id="title_p" required placeholder="Title">
                            </div>
                            <div class="form-group">
                                <label for="shorttitle_p">Short Title</label>
                                <input type="text" class="form-control" name="shorttitle" id="shorttitle_p" required placeholder="Short Title">
                            </div>
                            <div class="form-group">
                                <label for="videotype_p">Video Type</label>
                                <select type="text" class="form-control" name="videotype" id="videotype_p" required placeholder="Video Type">
                                    <option value="" selected disabled>Select Video Type</option>
                                    <option value="youtube">Youtube</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="videourl_p">Video URL</label>
                                <input type="text" class="form-control" name="videourl" id="videourl_p" required placeholder="Video URL">
                            </div>
                            <div class="form-group">
                                <label for="getHTML">Description</label>
                                <textarea name="desc" placeholder="Description" id="getHTML" class="form-control"  ></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>

    @forelse($listing as $index=> $list)
    <div id="exampleModalLive{{$index}}q" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLive{{$index}}qLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLive{{$index}}qLabel">Update Mediation</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('update-meditation',['id'=>$list->id])}}" method="post" >
                    @csrf
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="cat_uid_{{$list->id}}">Categories</label>
                                <select type="text" class="form-control" name="cat_uid"  id="cat_uid_{{$list->id}}" required placeholder="Category">
                                    <option value="" selected disabled>Select Category</option>
                                   @foreach($categories as $slist) <option value="{{$slist->uuid}}" @if($list->cat_uid==$slist->uuid) selected @endif>{{$slist->name}}</option> @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="title_p">Title</label>
                                <input type="text" class="form-control" value="{{$list->title}}" name="title" id="title_p" aria-describedby="emailHelp" required placeholder="Title">
                            </div>
                            <div class="form-group">
                                <label for="shorttitle_p">Short Title</label>
                                <input type="text" class="form-control"  value="{{$list->short_title}}" name="shorttitle" id="shorttitle_p" required placeholder="Short Title">
                            </div>
                            <div class="form-group">
                                <label for="videotype_p">Video Type</label>
                                <select type="text" class="form-control" name="videotype"  value="{{$list->video_type}}" id="videotype_p" required placeholder="Video Type">
                                    <option value="" selected disabled>Select Video Type</option>
                                    <option value="youtube">Youtube</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="videourl_p">Video URL</label>
                                <input type="text" class="form-control" name="videourl"  value="{{$list->video_url}}" id="videourl_p" required placeholder="Video URL">
                            </div>
                            <div class="form-group">
                                <label for="getHTML{{$index}}q">Description</label>
                                <textarea name="desc" placeholder="Description" class="form-control" id="getHTML{{$index}}q" >{{$list->description}}</textarea>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>
    @endforeach

    <!-- Apex Chart -->
    <script src="{{asset('assets/js/plugins/apexcharts.min.js')}}"></script>
    <!-- custom-chart js -->
    <script src="{{asset('assets/js/pages/dashboard-main.js')}}"></script>

    @foreach($listing as $index => $list )
    <script>
       
        $(document).on('submit','#storeUser{{$index}}q',()=>{
            var cont = tinymce.get("getHTML{{$index}}q").getContent();
            $('#getHTML{{$index}}q').html(cont);
            $('#storeUser{{$index}}q').submit();
        });
    </script>
    @endforeach
    <script>
       
       $(document).on('submit','#storeUser',()=>{
           var cont = tinymce.get("getHTML").getContent();
           $('#getHTML').html(cont);
           $('#storeUser').submit();
       });
   </script>
</body>

</html>