<!DOCTYPE html>
<html lang="en">

<head>
    <title>Exercise Videos</title>
    @include('includes.header')
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            @if(permission('exercise_videos','update'))<button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Add a New Exercise Video</button>@endif
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Exercise Videos</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Exercise Videos</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Thumbnail Image</th>
                                            <th>Video Type</th>
                                            <th>Category</th>
                                            <th>Status</th>
                                            @if(permission('exercise_videos','update') || permission('exercise_videos','delete'))
                                            <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($videos as $index => $list)
                                        <tr>
                                            <td>{{$list->id}}</td>
                                            <td><img src="{{env('APP_URL_STR').'exercise_vid_thumb/'}}{{$list->thumbnail_image}}" height="70" width="70"></td>
                                            <td>{{$list->video_type}}</td>
                                            <td>{{$list->cat->name}}</td>
                                            <td>
                                                @if($list->status==0)<span class="badge bg-gradient-dark">Inactive</span>@endif
                                                @if($list->status==1)<span class="badge bg-gradient-success">Active</span>@endif
                                                @if($list->status==2)<span class="badge bg-gradient-warning">Draft</span>@endif
                                            </td>
                                            @if(permission('exercise_videos','update') || permission('exercise_videos','delete'))
                                            <td>
                                              
                                                @if(permission('exercise_videos','sts'))<button class="btn btn-sm bg-gradient-dark"><i class="feather icon-eye"></i></button>@endif
                                                @if(permission('exercise_videos','update'))
                                                    <a href="{{route('status-exercise-videos',['id'=>$list->id])}}" onclick="return confirm('Change Status?')">
                                                            <button class="btn btn-sm bg-gradient-dark"><i class="feather icon-refresh-cw"></i></button>
                                                    </a>
                                                    <button class="btn btn-sm bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive{{$index}}q"><i class="feather icon-edit"></i></button>
                                                @endif
                                                @if(permission('exercise_videos','delete'))
                                                    <a href="{{route('delete-exercise-videos',['id'=>$list->id])}}" onclick="return confirm('Are you sure? Delete Video')">
                                                        <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button>
                                                    </a>
                                                @endif
                                            </td>
                                            @endif
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="5" class="text-center"> Empty</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                                {{ $videos->links('pagination.simple') }}
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')

    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add a New Exercise Video</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('save-exercise-videos')}}" id="storeUser" method="post" enctype='multipart/form-data'>
                    <div class="row">
                        @csrf
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="myname">Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="name" >
                                
                            </div>
                            <div class="form-group">
                                <label for="myname">Description <span class="text-danger">*</span></label>
                                <textarea  class="form-control" name="desc"></textarea>
                                
                            </div>
                            <div class="form-group">
                                <label for="myname">Duration <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" name="duration" >
                                
                            </div>
                            <div class="form-group">
                                <label for="myname">Thumbnail Image <span class="text-danger">*</span></label>
                                <input type="file" class="form-control" name="thumb_img" required>
                            </div>
                            <div class="form-group">
                                <label for="usertype">Video Type <span class="text-danger">*</span></label>
                                <select class="form-control" id="usertype" name="videotype" required>
                                    <option value="" selected disabled>Select</option>
                                    <option value="youtube">Youtube</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="usertype">Video Category <span class="text-danger">*</span></label>
                                <select class="form-control" name="cat" required>
                                    <option value="" selected disabled>Select</option>
                                   @foreach($cat as $list) <option value="{{$list->id}}">{{$list->name}}</option>@endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="exampleInputPassword1">Video URL <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="url" id="exampleInputPassword1" placeholder="URL" required>
                            </div>
                        </div>
                    
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>

    @foreach($videos as $index => $list)
    <div id="exampleModalLive{{$index}}q" class="modal fade"  role="dialog" aria-labelledby="exampleModalLive{{$index}}qLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLive{{$index}}qLabel">Edit Exercise Video</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('update-exercise-videos',['id'=>$list->id])}}"  method="post" enctype='multipart/form-data'>
                    <div class="row">
                        @csrf
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="myname">Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" value="{{$list->name}}" name="name" >
                                
                            </div>
                            <div class="form-group">
                                <label for="myname">Description <span class="text-danger">*</span></label>
                                <textarea  class="form-control"  name="desc">{{$list->desc}}</textarea>
                                
                            </div>
                            <div class="form-group">
                                <label for="myname">Duration <span class="text-danger">*</span></label>
                                <input type="number" class="form-control" value="{{$list->duration}}" name="duration" >
                                
                            </div>
                            <div class="form-group">
                                <label for="myname">Thumbnail Image <span class="text-danger">*</span></label>
                                <input type="file" class="form-control" name="thumb_img" >
                                <img src="{{env('APP_URL_STR').'exercise_vid_thumb/'}}{{$list->thumbnail_image}}" height="70" width="70">
                            </div>
                            <div class="form-group">
                                <label for="usertype">Video Type <span class="text-danger">*</span></label>
                                <select class="form-control" id="usertype" name="videotype" required>
                                    <option value="" selected disabled>Select</option>
                                    <option value="youtube" @if($list->video_type=='youtube') selected @endif >Youtube</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="usertype">Video Category <span class="text-danger">*</span></label>
                                <select class="form-control" name="cat" required>
                                    <option value="" selected disabled>Select</option>
                                   @foreach($cat as $elist) <option value="{{$elist->id}}" @if($elist->id==$list->exercise_video_categories_id) selected @endif>{{$elist->name}}</option>@endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="exampleInputPassword1">Video URL <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="url" value="{{$list->file_path}}" id="exampleInputPassword1" placeholder="URL" required>
                            </div>
                        </div>
                    
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>
    @endforeach
    <!-- Apex Chart -->
    <script src="{{asset('assets/js/plugins/apexcharts.min.js')}}"></script>
    <!-- custom-chart js -->
    <script src="{{asset('assets/js/pages/dashboard-main.js')}}"></script>

    <script>
        $(document).on('change','#usertype',(res)=>{
            var type = res.target.value;
            if(type=="free"){
                $('.paidUserCheck').hide();
                $('#paid_plan').removeAttr('required');
            }
            if(type=="paid"){
                $('.paidUserCheck').show();
                $('#paid_plan').attr('required',true);
            }
            console.log(type)
        });

        $(document).on('submit','#storeUser',()=>{
            if($('input[name=password]').val()!=$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','red 1px solid');
                $('.err-msg').html('Recheck Passwords')
                return false;
            }
            $('#storeUser').submit();
        });
        $(document).on('input','input[name=password],input[name=confirm_password]',()=>{
            if($('input[name=password]').val()==$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','green 1px solid');
                $('.err-msg').html('')
            }
        });
    </script>
</body>

</html>