<!DOCTYPE html>
<html lang="en">

<head>
    <title>{{$userDetail->name}} - Diet Plan </title>
    <style>
        .table-responsive {
            height: 600px;
        }
        .tox-tinymce{
            height:100% !important;
        }
    </style>
    @include('includes.header')
    <script src="https://cdn.tiny.cloud/1/vzsbabl41dquoqb8uiq1co621duklluitrrj6akhlplahhqx/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    <script>
    tinymce.init({
        selector: 'textarea',
        file_picker_types: 'image',
        automatic_uploads: true,
        plugins: 'image,lists advlist',
      
        file_picker_callback: (cb, value, meta) => {
            const input = document.createElement('input');
            input.setAttribute('type', 'file');
            input.setAttribute('accept', 'image/*');

            input.addEventListener('change', (e) => {
            const file = e.target.files[0];

            const reader = new FileReader();
            reader.addEventListener('load', () => {
                /*
                Note: Now we need to register the blob in TinyMCEs image blob
                registry. In the next release this part hopefully won't be
                necessary, as we are looking to handle it internally.
                */
                const id = 'blobid' + (new Date()).getTime();
                const blobCache =  tinymce.activeEditor.editorUpload.blobCache;
                const base64 = reader.result.split(',')[1];
                const blobInfo = blobCache.create(id, file, base64);
                blobCache.add(blobInfo);

                /* call the callback and populate the Title field with the file name */
                cb(blobInfo.blobUri(), { title: file.name });
            });
            reader.readAsDataURL(file);
            });

            input.click();
        },
        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link table mergetags | align lineheight | tinycomments | checklist numlist bullist indent outdent | emoticons charmap | removeformat | link image',
        ai_request: (request, respondWith) => respondWith.string(() => Promise.reject("See docs to implement AI Assistant")),
        setup: function (editor) {
            editor.on('keydown', function (e) {
            if (e.key === 'Backspace') {
               const node = editor.selection.getNode();
                if (node.nodeName === 'LI' && node.textContent.trim() === '') {
                    e.preventDefault();
                    editor.execCommand('RemoveList');
                }
            }
            });
        }
    });
    </script>
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            @if(permission('app_users','update'))<button class="m-b-10 btn bg-gradient-success" id="storeUser">Save</button>@endif
                            </div>
                            <div class="float-left">
                                <button class="m-b-10 btn bg-gradient-dark" onclick="goBack()"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button>
                            </div>
                            
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >{{$userDetail->name}} - Diet Plan</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>{{$userDetail->name}} - Diet Plan</h5>
                            <div class="float-right">
                            @if(permission('app_users','update'))<button class="m-b-10 btn bg-gradient-info btn-sm" id="copyDiet"> <i class="fa fa-copy" aria-hidden="true"></i> Copy Diet Plan</button>@endif
                            </div>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <textarea name="html" id="getHTML" >{!! $userDetail->diet_plan !!}</textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')

    <script>
       
       $(document).on('click','#storeUser',()=>{
           var cont = tinymce.get("getHTML").getContent();
            //    $('#getHTML').html(cont);
           console.log(cont)
          
            $.ajax({url:'{{route("update-diet-plan",["id"=>$userDetail->id])}}',type: 'PUT',data:{html:cont,_token:"{{csrf_token()}}"},
                    success: function(result) {
                        $("#gen-loading").hide();
                        Swal.fire({
                            position: "top-end",
                            icon: "success",
                            title: result.message,
                            showConfirmButton: false,
                            timer: 1500
                        });
                    },
                    error: function(request,msg,error) {
                        $("#gen-loading").hide();
                        console.log(request)
                        Swal.fire({
                            position: "top-end",
                            icon: "error",
                            title: "Something went wrong!",
                            showConfirmButton: false,
                            timer: 1500
                        })
                    }
                }
            );
       });

       var users = JSON.parse(`{!!json_encode($all_user);!!}`);
     

        $(document).on('click','#copyDiet',async ()=>{
           
            const { value: fruit } = await Swal.fire({
                title: "User",
                input: "select",
                html:'<small>&#x2713 means diet plan exists</small>',
                inputOptions: {
                    @foreach($all_user as $user)
                    {{$user->id}}: "@if(!empty($user->diet_plan)) &#x2713; @endif{{$user->name.' - '.$user->email}}",
                    @endforeach
                },
                inputPlaceholder: "Select a user",
                showCancelButton: true,
                inputValidator: (value) => {
                    return new Promise(async (resolve) => {
                        if (value == '') {
                            resolve("Select user");
                        } 
                        let obj = users.find(o => o.id == value);
                        if (obj.diet_plan == null) {
                            resolve("No Find Diet Plan In This User ");
                        } else {
                            resolve();
                        }
                    });


                }
            });
            if (fruit) {
                let obj = users.find(o => o.id == fruit);
                if (obj.diet_plan != null) {
                    Swal.fire({
                        position: "top-end",
                        icon: "success",
                        title: "Diet Plan Cloned",
                        showConfirmButton: false,
                        timer: 1500
                    });
                    tinymce.get("getHTML").setContent(atob(obj.diet_plan));
                }
            }
        });

        function goBack() {
            history.back()
        }
   </script>
</body>

</html>