<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WorkoutLog extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id',
        'workout_days_uuid',
        'weight',
        'reps',
        'sets',
        'time',
        'difficulty',
        'week_count',
        'next_week',
        'id'
    ];
    public function workout_days_uuid()
        {
            return $this->belongsTo(WorkoutDay::class,'workout_days_uuid','uuid');
        }

    public function getCreatedAtAttribute($e)
        {
            $e = date('Y-m-d',strtotime($e));
            return $e;
        }
    public static function boot() {
        parent::boot();
    
        static::creating(function (WorkoutLog $logs) {
            if($logs->difficulty<=5){
                $logs->next_week = "weight_".($logs->weight+10);
            } else if($logs->difficulty>5 && $logs->difficulty<=8){
                $logs->next_week = "weight_".($logs->weight+5);
            } else if($logs->difficulty>=9){
                $logs->next_week = "reps_".($logs->reps+1);
            }
            $getLastWeek = WorkoutLog::where('user_id',$logs->user_id)->where('workout_days_uuid',$logs->workout_days_uuid)->first();
            if(!empty($getLastWeek->next_week)){
                // $logs->week_count = ((int)$getLastWeek->next_week??1)+1;
            }
            
            // $logs->uuid = Str::uuid()->toString();
        });
    }
}
