<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Plan extends Model
{
    use HasFactory;
    public function scopeActive()
    {
        return $this->where('status',1);
    }
    public function getPermissionsAttribute($e)
        {
            return json_decode($e);
        }
    public function getFeaturesAttribute($e)
        {
            return json_decode($e);
        }
    public function getFinalPriceAttribute($e)
        {
            return $this->amount * ( (100-$this->discount) / 100 );
        }
}
