<?php
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use App\Models\Permission;
use App\Models\Role;
use App\Models\Notification;
use App\Models\RecipeIngredient;
use App\Models\RecipeList;
use App\Models\RecipeLog;
use App\Models\RecipeLogList;
use App\Models\WorkoutDay;
use Illuminate\Mail\Mailable;

if (! function_exists('permission')) {
    function permission($sub,$level) {
        $getArray = getPermissionList(Auth::user()->role)[$sub];
        if(is_array($getArray)){
            $getQ = in_array($level,$getArray);//(string)array_search($level,getPermissionList(Auth::user()->role)[$sub]);
       
            if($getQ){
                return 1;
            } else {
                return 0;
            }
        }

        return 0;
    //    return Role::where('id',Auth::user()->role_id)->whereJsonContains('access_area',$key)->exists();
    }
}
// if (! function_exists('getRoleName')) {
//     function getRoleName() {
//        return Role::where('id',Auth::user()->role_id)->first()->role_name;
//     }
// }

if (! function_exists('getPermissionList')) {
    function getPermissionList($role_name) {
        $permissions = [];
        $userRole = Role::where('name',$role_name)->first();
        $userPermission = Permission::where('role_id',$userRole->id)->get();
        foreach($userPermission as $list){
            $permissions[$list->name] =  json_decode($list->permissions);
        }
        return $permissions;
    }
}

if(!function_exists('searchFromJSON')){
    function searchFromJSON($list,$level){
        try{
            $getQ = (string)array_search($level,$list);
            if($getQ != "" || $getQ == 0){
                return true;
            } else {
                return false;
            }
        } catch (Throwable $e){
            return false;
        }
    }
}

if(!function_exists('notify_user')){
    function notify_user($send_to,$title,$message){
        $authuser=Auth::user()->id??null;
        Notification::insert([
            "user_id"=>$send_to,
            "is_from_id"=>$authuser==null?User::first()->id:$authuser,
            "title"=>$title,
            "message"=>$message,
            "datetime"=>date('Y-m-d H:i:s',strtotime('now'))
        ]);

        $userToId = User::where('id',$send_to)->first()->wonderpush_install_id;
        if(!empty($userToId)){
            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, "https://management-api.wonderpush.com/v1/deliveries");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array(
                'accessToken' => "ODRmYzRhMTM1NDU3NmQzMWI4YmU3MWVmMmM2YmI3YzVkOWFiOGQ3ZDFmZjI3OGVjYWJlMDI5ODRjZmYzNzE4ZQ",
                'targetInstallationIds' => $userToId,
                'notification' => json_encode(['alert'=>['title'=>$title,'text'=>$message]])
            )));
            $rawResponse = curl_exec($ch);
    
            if (curl_errno($ch)) {
    
                // echo 'Error: ' . curl_error($ch);
    
            } else {
    
                $response = json_decode($rawResponse, true);
                if (isset($response['success']) && $response['success'] === true) {
                    // return $response;
                } else if (isset($response['error']['status'])
                        && isset($response['error']['code'])
                        && isset($response['error']['message'])) {
                    // echo 'Error ' . $response['error']['status']
                    // . ' code ' . $response['error']['code']
                    // . ': ' . $response['error']['message'];
                } else {
                    // echo 'Error: ' . $rawResponse;
                }
    
            }
    
            curl_close($ch);
        }
        
    }
}

if(!function_exists('globalMail')){
    function globalMail($to_name,$to_email,$subject,$html){
        try {
            $mailable = new Mailable();
            $mailable
                ->from('fitness.junction.amritsar@gmail.com','Fitness Junction')
                ->to($to_email,$to_name)
                ->subject($subject)
                ->html($html);
            $result = Mail::send($mailable);
            return true;
        } catch (\Symfony\Component\Mailer\Exception\TransportException $e) {
            return false;
        }
    }
}


if(!function_exists('pushNotification')){
    function pushNotification($send_to,$title,$message){
        $userToId = User::where('id',$send_to)->first()->wonderpush_install_id;
        if(!empty($userToId)){
            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, "https://management-api.wonderpush.com/v1/deliveries");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array(
                'accessToken' => "ODRmYzRhMTM1NDU3NmQzMWI4YmU3MWVmMmM2YmI3YzVkOWFiOGQ3ZDFmZjI3OGVjYWJlMDI5ODRjZmYzNzE4ZQ",
                'targetInstallationIds' => $userToId,
                'notification' => json_encode(['alert'=>['title'=>$title,'text'=>$message]])
            )));
            $rawResponse = curl_exec($ch);
    
            if (curl_errno($ch)) {
    
                // echo 'Error: ' . curl_error($ch);
    
            } else {
    
                $response = json_decode($rawResponse, true);
                if (isset($response['success']) && $response['success'] === true) {
                    // return $response;
                } else if (isset($response['error']['status'])
                        && isset($response['error']['code'])
                        && isset($response['error']['message'])) {
                    // echo 'Error ' . $response['error']['status']
                    // . ' code ' . $response['error']['code']
                    // . ': ' . $response['error']['message'];
                } else {
                    // echo 'Error: ' . $rawResponse;
                }
    
            }
    
            curl_close($ch);
        }
        
    }
}

if(!function_exists('dataTableCommon')){
    function dataTableCommon($request,$collection,$search,$where,$with){
        //Collection Modal
        $userQry = $collection;

        //Manage Where Conditions 
        foreach($where as $qry){
            $whereSplit = explode(',',$qry);
            if(count($whereSplit)==2){
                //Ex: 'role,appuser'
                $userQry->where($whereSplit[0],$whereSplit[1]);
            } else if(count($whereSplit)==3){
                //Ex: 'role,'<>',appuser'
                $userQry->where($whereSplit[0],$whereSplit[1],$whereSplit[2]);
            } else if(count($whereSplit)==4){
                if($whereSplit[0]=="where"){
                    //Ex: 'where','role,'<>',appuser'
                    $userQry->where($whereSplit[1],$whereSplit[2],$whereSplit[3]);
                } else if($whereSplit[0]=="orwhere"){
                    //Ex: 'orwhere','role,'<>',appuser'
                    $userQry->orWhere($whereSplit[1],$whereSplit[2],$whereSplit[3]);
                } else if($whereSplit[0]=="wheredate"){
                    //Ex: 'wheredate','role,'==',appuser'
                    $userQry->whereDate($whereSplit[1],$whereSplit[2],base64_decode($whereSplit[3]));
                } else if($whereSplit[0]=="wherein"){
                     //Ex: 'wherein','role,'<>',appuser','YXBwdXNlcg=='
                    $userQry->whereIn($whereSplit[1],$whereSplit[2],json_decode(base64_decode($whereSplit[3])));
                } else if($whereSplit[0]=="wherebetween"){
                    //Ex: 'wherebetween','role,'',appuser','YXBwdXNlcg=='
                    $ar_val = json_decode(base64_decode($whereSplit[3]),true);
                    $userQry->whereBetween($whereSplit[1],$ar_val);
                }
            }
           
        }
        
        //Search
        if(!empty($request['search']['value'])){
            $serachQ = $request['search']['value'];
            $we = true;
            foreach($search as $field){
                if($we){
                    $userQry->where($field,'like','%'.$serachQ.'%');
                    $we = false;
                } else {
                    $userQry->orWhere($field,'like','%'.$serachQ.'%');
                }
            }
        }

        //Col Orders
        if($request->has('order')){
            $colID = $request['order'][0]['column'];
            $colName = $request['columns'][$colID]['data'];
            
            if(!empty($colName) && !empty($request['order'][0]['dir'])){
                $userQry->orderBy($colName, $request['order'][0]['dir']);
            }
        } else {
            $userQry->orderBy('id', 'asc');
        }

        //Collect Relavant Data From Another Modal
        if(count($with)>0){
            $userQry->with($with);
        }
        //Total Records
        $total = $userQry->count();

        //Page Results According Page No & No of Records Per Page
        $user = $userQry->offset($request->start)->limit($request->length)->get();

        //Final Result
        $getRes = [
            "recordsTotal"=>$total,
            "recordsFiltered"=> $total,
            "data"=>$user,
        ];
        return $getRes;
    }
}

if(!function_exists('getRecipeCalories')){
    function getRecipeCalories($recipe_ids,$full=false)
        {
            $recipes = RecipeList::whereIn('id',$recipe_ids)->get();
            $getFinalCalories = 0;
            $getProtein = 0;
            $getCrabs = 0;
            $getFats = 0;
            foreach($recipes as $list){
                $ingredients = RecipeIngredient::whereIn('id',json_decode($list->recipe_ingredients))->get();
                $recipe_ingredients =  $ingredients->groupBy('id')->toArray();
                $list->recipe_steps = json_decode($list->recipe_steps);
                $list->recipe_ingredients = $recipe_ingredients;
            
                $calories = 0;
                $protein = 0;
                $crabs = 0;
                $fats = 0;
                foreach($list->recipe_steps as $relist){
                    if($recipe_ingredients[$relist->id][0]['qty']=='qty'){
                        $calc = $recipe_ingredients[intval($relist->id)][0]['calories']*intval($relist->qty);
                        $pro = $recipe_ingredients[intval($relist->id)][0]['protein']*intval($relist->qty);
                        $crab = $recipe_ingredients[intval($relist->id)][0]['crabs']*intval($relist->qty);
                        $fat = $recipe_ingredients[intval($relist->id)][0]['fats']*intval($relist->qty);
                    } else {
                        $calc = ($recipe_ingredients[intval($relist->id)][0]['calories']/$recipe_ingredients[$relist->id][0]['qty'])*intval($relist->qty);
                        $pro = ($recipe_ingredients[intval($relist->id)][0]['protein']/$recipe_ingredients[$relist->id][0]['qty'])*intval($relist->qty);
                        $crab = ($recipe_ingredients[intval($relist->id)][0]['crabs']/$recipe_ingredients[$relist->id][0]['qty'])*intval($relist->qty);
                        $fat = ($recipe_ingredients[intval($relist->id)][0]['fats']/$recipe_ingredients[$relist->id][0]['qty'])*intval($relist->qty);
                    }
                    
                    $calories += $calc;
                    $protein += $pro;
                    $crabs += $crab;
                    $fats += $fat;
                }
                $getFinalCalories += round($calories);
                $getProtein += round($protein);
                $getCrabs += round($crabs);
                $getFats += round($fats);
                $list->calories = round($calories);
                $list->protein = round($protein);
                $list->crabs = round($crabs);
                $list->fats = round($fats);
            }
   
            if($full){
                return [
                    'calories'=>$getFinalCalories,
                    'protein'=>$getProtein,
                    'crabs'=>$getCrabs,
                    'fats'=>$getFats
                ];
            }
            return $getFinalCalories;
        }
}
if(!function_exists('getTempRecipeCalories')){
    function getTempRecipeCalories($recipe_ids,$full=false)
        {

            $recipes = RecipeLogList::whereIn('id',$recipe_ids)->get();
            $getFinalCalories = 0;
            $getProtein = 0;
            $getCrabs = 0;
            $getFats = 0;
            foreach($recipes as $list){
                $ingredients = RecipeIngredient::whereIn('id',json_decode($list->recipe_ingredients))->get();
                $recipe_ingredients =  $ingredients->groupBy('id')->toArray();
                $list->recipe_steps = json_decode($list->recipe_steps);
                $list->recipe_ingredients = $recipe_ingredients;
            
                $calories = 0;
                $protein = 0;
                $crabs = 0;
                $fats = 0;
                foreach($list->recipe_steps as $relist){
                    if($recipe_ingredients[$relist->id][0]['qty']=='qty'){
                        $calc = $recipe_ingredients[intval($relist->id)][0]['calories']*intval($relist->qty);
                        $pro = $recipe_ingredients[intval($relist->id)][0]['protein']*intval($relist->qty);
                        $crab = $recipe_ingredients[intval($relist->id)][0]['crabs']*intval($relist->qty);
                        $fat = $recipe_ingredients[intval($relist->id)][0]['fats']*intval($relist->qty);
                    } else {
                        $calc = ($recipe_ingredients[intval($relist->id)][0]['calories']/$recipe_ingredients[$relist->id][0]['qty'])*intval($relist->qty);
                        $pro = ($recipe_ingredients[intval($relist->id)][0]['protein']/$recipe_ingredients[$relist->id][0]['qty'])*intval($relist->qty);
                        $crab = ($recipe_ingredients[intval($relist->id)][0]['crabs']/$recipe_ingredients[$relist->id][0]['qty'])*intval($relist->qty);
                        $fat = ($recipe_ingredients[intval($relist->id)][0]['fats']/$recipe_ingredients[$relist->id][0]['qty'])*intval($relist->qty);
                    }
                    
                    $calories += $calc;
                    $protein += $pro;
                    $crabs += $crab;
                    $fats += $fat;
                }
                $getFinalCalories += round($calories);
                $getProtein += round($protein);
                $getCrabs += round($crabs);
                $getFats += round($fats);
                $list->calories = round($calories);
                $list->protein = round($protein);
                $list->crabs = round($crabs);
                $list->fats = round($fats);
            }
   
            if($full){
                return [
                    'calories'=>$getFinalCalories,
                    'protein'=>$getProtein,
                    'crabs'=>$getCrabs,
                    'fats'=>$getFats
                ];
            }
            return $getFinalCalories;
        }
}

if(!function_exists('getUserCalories')){
    function getUserCalories($date,$user,$full=false)
        {
            $recipe = RecipeLog::whereDate('date',$date)->where('user_id',$user)->where('log_type',1)->pluck('recipes');

            $temprecipe = RecipeLog::whereDate('date',$date)->where('user_id',$user)->where('log_type',2)->pluck('recipes');

            $takenCalories = 0;

            $getFinalCalories = 0;
            $getProtein = 0;
            $getCrabs = 0;
            $getFats = 0;
            foreach($recipe as $list){
                if($full){
                    $takenCalories = getRecipeCalories(json_decode(($list)),$full);
                    $getFinalCalories += $takenCalories['calories'];
                    $getProtein += $takenCalories['protein'];
                    $getCrabs += $takenCalories['crabs'];
                    $getFats += $takenCalories['fats'];
                } else {
                    $takenCalories += getRecipeCalories(json_decode(($list)),$full);
                }
            }
            foreach($temprecipe as $list){
                // print_r($list);
                // die;
                if($full){
                    $takenCalories = getTempRecipeCalories(json_decode(($list)),$full);
                    $getFinalCalories += $takenCalories['calories'];
                    $getProtein += $takenCalories['protein'];
                    $getCrabs += $takenCalories['crabs'];
                    $getFats += $takenCalories['fats'];
                } else {
                    $takenCalories += getTempRecipeCalories(json_decode(($list)),$full);
                }
            }
            if($full){
                return [
                    'calories'=>$getFinalCalories,
                    'protein'=>$getProtein,
                    'crabs'=>$getCrabs,
                    'fats'=>$getFats
                ];
            }
            return $takenCalories;
        }
}

if(!function_exists('getCurrentBMR')){
    function getCurrentBMR($user)
        {
            $userDetail = User::find($user);

            $currentBmr = 0;

            if(!empty($userDetail->bmr)){
                $currentBmr = $userDetail->bmr;
            } else {
                //Current BMR CALC
                $age = round(((strtotime('now')-strtotime($userDetail->dob))/86400)/365);
                $getHeightCalc = explode('_',$userDetail->height);
                $cbmr = '';
                if(count($getHeightCalc)>1){
                    if($getHeightCalc[1]=='cm'){
                        //  $getH = explode('.',round((floatval($getHeightCalc[0])/30.48),2));
                        $feet = 0;
                        $inches = $getHeightCalc[0];
                        $totalheight = $inches;
                        
                    } else if($getHeightCalc[1]=='ft'){
                        $getH = explode('.',$getHeightCalc[0]);
                        $feet = $getH[0];
                        $inches = $getH[1];
                        $totalheight = ($inches + ($feet*12))*2.54;
                    }
                    
                    $getWeightCl = explode('_',$userDetail->weight);
                    //  return $getWeightCl;
                    $weight = 0;
                    if(count($getWeightCl)>0){
                        if($getWeightCl[1]=="lbs"){
                            $weight = floatval($getWeightCl[0])/2.205;
                        } else {
                            $weight = (int)$getWeightCl[0];
                        }
                    }
                
                    $exercise = 0;
                    if($userDetail->activity_level=="intermediate"){
                        $exercise = 1.375;
                    } else if($userDetail->activity_level=="advanced"){
                        $exercise = 1.70;
                    }

                    
                    $answer = 5 + (((10*$weight) + (6.25*$totalheight)) - (5*$age));
                    if($exercise>0){
                        $answer = $answer*$exercise;
                    }
                    $cbmr = round($answer);

                    $currentBmr = $cbmr;
                }
            }
            return $currentBmr;
        }
}

if(!function_exists('chatGPTExtractResult')){
    function chatGPTExtractResult($msg)
        {
            $requestData = array(
                "model" => "gpt-4o-mini",
                "messages" => array(
                    array(
                        "role" => "user",
                        "content" => $msg
                    )
                )
            );

            $requestDataEnc = json_encode($requestData);
            $ckey = "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";
            $c_url = "https://api.openai.com/v1/chat/completions";
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $c_url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'Authorization: Bearer '.$ckey,
            ]);

            curl_setopt($ch, CURLOPT_POSTFIELDS, $requestDataEnc);

            $response = json_decode(curl_exec($ch));

            curl_close($ch);

            return $response->choices[0]->message->content;
        }

    
}

if(!function_exists('')){
    function generateStrengthTypes()
        {
            $getStrengthTypes = WorkoutDay::where('exersice_type','strength')->whereNull('user_id')->get(['uuid','title']);
            $getResults = chatGPTExtractResult('from this list which exercises carring weight '.$getStrengthTypes." show records same as input only json value");
            return $getResults;
        }
}