export type DealStatus = 'NEW' | 'CHAT' | 'PAPERS' | 'SIGNING' | 'PROGRESS' | 'DOCUMENT';

export interface Deal {
  id: string;
  title: string;
  amount: number;
  currency: string;
  contactName: string;
  responsiblePerson: string;
  responsibleAvatar?: string;
  status: DealStatus;
  dateText: string;
  type: string;
  modifiedDate: string;
  photoUrl?: string;
  taskStatus: string;
  activityCount: number;
  hasPhone?: boolean;
  hasEmail?: boolean;
  hasChat?: boolean;
  lastActivityTime?: string;
  isRepeat?: boolean;
}
