
import React, { useState, useEffect } from 'react';
import { Sparkles, MessageSquare, Loader2, RefreshCcw, Send, BrainCircuit } from 'lucide-react';
import type { Deal } from '../types';

interface Insight {
  insight: string;
  action: string;
  priority: string;
}

export const InsightsPanel: React.FC<{ deals: Deal[] }> = ({ deals }) => {
  const [insights, setInsights] = useState<Insight[]>([]);
  const [loading, setLoading] = useState(false);
  return (
    <div className="w-[340px]  border-l border-[#d6dee2] h-full flex flex-col shrink-0 shadow-lg">
      <div className="p-5 border-b border-[#eef2f4] flex items-center justify-between bg-white">
        <div className="flex items-center gap-2.5">
          <div className="w-8 h-8 bg-gradient-to-tr from-blue-400 to-purple-500 rounded-lg flex items-center justify-center text-white">
            <BrainCircuit size={18} />
          </div>
          <div>
            <h2 className="font-bold text-[#333] text-[15px]">Bitrix24 <span className="text-blue-500">CoPilot</span></h2>
            <div className="flex items-center gap-1.5">
              <div className="w-1.5 h-1.5 bg-green-500 rounded-full animate-pulse"></div>
              <span className="text-[10px] text-gray-400 font-bold uppercase">Ready to assist</span>
            </div>
          </div>
        </div>
        <button
          onClick={() => { }}
          disabled={loading}
          className="text-gray-400 hover:text-blue-500 transition-colors"
        >
          <RefreshCcw size={16} className={loading ? 'animate-spin' : ''} />
        </button>
      </div>

      <div className="flex-1 overflow-y-auto p-5 space-y-5 custom-scrollbar bg-[#f8fafb]">
        {loading ? (
          <div className="flex flex-col items-center justify-center h-64 text-gray-400">
            <div className="relative">
              <Loader2 className="animate-spin text-blue-500 mb-4" size={40} />
              <Sparkles className="absolute -top-1 -right-1 text-yellow-400 animate-bounce" size={16} />
            </div>
            <p className="text-[13px] font-bold text-gray-500">CoPilot is thinking...</p>
          </div>
        ) : (
          <>
            <div className="bg-white border border-[#eef2f4] rounded-xl p-4 shadow-sm relative">
              <div className="flex items-center gap-2 mb-3">
                <Sparkles size={14} className="text-yellow-500" />
                <span className="text-[11px] font-extrabold text-[#525c69] uppercase tracking-wider">Analysis Result</span>
              </div>
              <p className="text-[13px] text-gray-700 leading-relaxed italic">
                "I've analyzed your pipeline. You have ${deals.reduce((s, d) => s + d.amount, 0).toLocaleString()} in potential revenue. Here are my suggestions:"
              </p>
            </div>

            {insights.map((item, idx) => (
              <div key={idx} className="bg-white rounded-xl p-4 border border-blue-50 hover:border-blue-200 transition-all shadow-sm">
                <div className="flex items-center justify-between mb-3">
                  <span className={`text-[9px] font-bold px-2 py-0.5 rounded-full ${item.priority === 'High' ? 'bg-red-50 text-red-500' : 'bg-blue-50 text-blue-500'
                    }`}>
                    {item.priority.toUpperCase()} PRIORITY
                  </span>
                </div>
                <h3 className="text-[14px] font-bold text-[#333] mb-2 leading-tight">
                  {item.insight}
                </h3>
                <div className="text-[12px] text-gray-600 bg-gray-50 rounded-lg p-3 border-l-2 border-blue-400">
                  {item.action}
                </div>
              </div>
            ))}
          </>
        )}
      </div>

      <div className="p-4 bg-white border-t border-[#eef2f4]">
        <div className="relative">
          <input
            type="text"
            placeholder="Ask CoPilot about these deals..."
            className="w-full bg-[#f4f7f8] border border-gray-100 rounded-full py-2.5 pl-4 pr-12 text-[13px] focus:outline-none focus:ring-1 focus:ring-blue-400"
          />
          <button className="absolute right-2 top-1.5 w-8 h-8 bg-blue-500 text-white rounded-full flex items-center justify-center hover:bg-blue-600 shadow-sm">
            <Send size={14} />
          </button>
        </div>
        <div className="mt-3 text-[10px] text-center text-[#a8adb4]">
          Gemini 3 Pro • Enhanced Sales Intelligence
        </div>
      </div>
    </div>
  );
};
