<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DiscoveryEngine;

class GoogleCloudDiscoveryengineV1alphaQuery extends \Google\Collection
{
  protected $collection_key = 'parts';
  protected $partsType = GoogleCloudDiscoveryengineV1alphaQueryPart::class;
  protected $partsDataType = 'array';
  /**
   * Output only. Unique Id for the query.
   *
   * @var string
   */
  public $queryId;
  /**
   * Plain text.
   *
   * @var string
   */
  public $text;

  /**
   * Query content parts.
   *
   * @param GoogleCloudDiscoveryengineV1alphaQueryPart[] $parts
   */
  public function setParts($parts)
  {
    $this->parts = $parts;
  }
  /**
   * @return GoogleCloudDiscoveryengineV1alphaQueryPart[]
   */
  public function getParts()
  {
    return $this->parts;
  }
  /**
   * Output only. Unique Id for the query.
   *
   * @param string $queryId
   */
  public function setQueryId($queryId)
  {
    $this->queryId = $queryId;
  }
  /**
   * @return string
   */
  public function getQueryId()
  {
    return $this->queryId;
  }
  /**
   * Plain text.
   *
   * @param string $text
   */
  public function setText($text)
  {
    $this->text = $text;
  }
  /**
   * @return string
   */
  public function getText()
  {
    return $this->text;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDiscoveryengineV1alphaQuery::class, 'Google_Service_DiscoveryEngine_GoogleCloudDiscoveryengineV1alphaQuery');
